const queryString = window.parent.location.search;
const urlParams = new URLSearchParams(queryString);

$(document).ready(function(){
  getAPIParams({}, 'get_gantt_list');
});

// ################################## GET API PARAMS OPERATION ################################# //
function getAPIParams(data, api) {
	if (typeof(data) == 'string' && data != '' && isJson(data)) { data = JSON.parse(data) }
	let APIs = {
		"get_gantt_list": {
      "url": `https://soporte.globalbco.com/TareasGantt.php?record=${urlParams.get('id')}`,
			"method": "GET",
			"success": "success_get_gantt_list"
		},
	}
	let url = APIs[api]['url'];
	let method = APIs[api]['method'];
	let success = APIs[api]['success'];
	API_control(url, data, method, success);
}

// #################################### API CONTROL OPERATION ################################## //
function API_control(url, data, method, success) {
	let formData = '', send_formdata = false;
	data['_method'] = method;
	data['userId'] = $("#current_user_id").val();
	// if (data['contains_file']) {
	// 	formData = new FormData();
	// 	Object.entries(data).forEach(([key, value]) => { formData.append(key, value) });
	// 	data = formData;
	// 	send_formdata = true;
	// }
	$("#loader").css("display","flex");
  console.log("-----------------------------------");
  console.log(data);
  console.log("-----------------------------------");
	$.ajax({
		url: url,
		data: data,
		processData: send_formdata ? false : true,
		contentType: send_formdata ? false : 'application/x-www-form-urlencoded; charset=UTF-8',
		headers: {
			'X-XSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
		},
		type: method,
		success: function(dataResponse) {
			// console.log(dataResponse);
			dataResponse = JSON.parse(dataResponse);
			console.log(dataResponse);
      console.log("-----------------------------------");
			$("#loader").hide();
			$("label > i.validate_icon").remove();
			let error = dataResponse['message'];
      successAPI(success, dataResponse);
		},
		error: function(error) {
			console.log(error);
			$("#loader").hide();
			// modalControl('error_api');
		}
	});
}	

// ######################################### SUCCESS API ####################################### //
function successAPI(success, data) {
  switch (success) {
    // ------------------------ success_get_list_applications ------------------------ //
    case "success_get_gantt_list":
      var groupBy = function(xs, key) {
        return xs.reduce(function(rv, x) {
          (rv[x[key].trim()] = rv[x[key].trim()] || []).push(x);
          return rv;
        }, {});
      };
      data = groupBy(data, 'hitoname');
      console.log(data);
      let data_gantt = [], counter = 0, total_records = 0;
      Object.values(data).map((sprint, index1) => {
        sprint.unshift({
          "hitoname": "",
          "tareaname": "",
          "inicio": moment().valueOf(),
          "fin": moment().valueOf(),
          "progreso": ""
        })
        sprint.map((task, index2) => {
          let data = {
            desc: task['tareaname'],
            values: [{
              from: moment(task['inicio']).valueOf(),
              to: moment(task['fin']).valueOf(),
              label: task['tareaname'],
              customClass: `color${counter} header${index1} w${task['progreso'].replace("%","")}`
            }],
          }
          if (index2 == 1) { 
            data['name'] = task['hitoname'];
            data['cssClass'] = `header${index1} c${index1}`
          }
          data_gantt.push(data);
          total_records++;
        });
        counter++;
        if (counter > 9) { counter = 0 }
      })
      console.log(data_gantt);
      $("#gantt").gantt({
        source: data_gantt,
        navigate: "scroll",
        scale: "days",
        minScale: "days",
        maxScale: "months",
        itemsPerPage: 10000000,
        scrollToToday: false,
        // useCookie: true,
        dow: ["D", "L", "M", "M", "J", "V", "S"],
        waitText: 'Cargando...',
        // onItemClick: function(data) {
        //   alert("Item clicked - show some details");
        // },
        // onAddClick: function(dt, rowId) {
        //   alert("Empty space clicked - add an item!");
        // },
        onRender: function() {
          console.log("HOLAAAAAAA");
          $("#gantt .row.name").each(function(index){
            let color = $(this).find(".fn-label").attr("class").split(' ')[2];
            if (color) { $(this).addClass(`color${color.split('')[1]} main`) }
          });
          $("#gantt .row.fn-wide, #gantt .row.name:not(.main), #gantt .bar.w").remove();
          $("#gantt .fn-gantt .dataPanel").css("height",`${(total_records+4)*24}px`);
          $("#gantt .leftPanel .row.main").each(function(index){
            $(this).addClass(`sprint${index}`).attr({"data-toggle":"collapse", "data-target":`#list_activities${index}, #list_bars${index}`});
            $(this).nextUntil(".row.main").addClass(`sprint${index}`);
            $(`#gantt .leftPanel .row.sprint${index}`).wrapAll("<div class='content_sprint'></div>");
            $(`#gantt .leftPanel .row.sprint${index}:not(.main)`).wrapAll(`<div id='list_activities${index}' class='list_activities collapse in'></div>`);
            $(`#gantt .rightPanel .bar.header${index}`).wrapAll(`<div id='list_bars${index}' class='list_bars collapse in'></div>`);
          });
          $('#gantt .list_bars').on('hide.bs.collapse', function () {
            let HGrid = $("#gantt .dataPanel").outerHeight();
            let NBars = $(this).find(".bar").length;
            let translateY = NBars*24;
            $(`#gantt .list_bars.collapse:not(.in)`).each(function(){
              let bars = $(this).find(".bar").length;
              translateY += bars*24; 
            });
            $("#gantt .dataPanel").css("height", HGrid-(NBars*24));
            $(this).nextAll("#gantt .list_bars").css("transform", `translateY(-${translateY}px)`);
          });
          $('#gantt .list_bars').on('show.bs.collapse', function () {
            let HGrid = $("#gantt .dataPanel").outerHeight();
            let NBars = $(this).find(".bar").length;
            $("#gantt .dataPanel").css("height", HGrid+(NBars*24));
          })
          $('#gantt .list_bars').on('shown.bs.collapse', function () {
            $(`#gantt .list_bars`).each(function(){
              let translateY = 0;
              $(this).prevAll(`#gantt .list_bars.collapse:not(.in)`).each(function(){
                let bars = $(this).find(".bar").length;
                translateY += bars*24; 
              });
              $(this).css("transform", `translateY(-${translateY}px)`);
            })
          });
          let HGantt = $("#gantt").outerHeight(); 
          let gantt_iframe = parent.document.getElementById('gantt_iframe');
          if (gantt_iframe) { gantt_iframe.height = HGantt }
        }
      });
      $("#gantt").popover({
        selector: ".bar",
        title: function _getItemText() { return ' '; },
        container: '#gantt',
        content: function _getItemText() { 
          popover_color = $(this).attr("class").split(' ')[1];
          popover_header = $(this).attr("class").split(' ')[2];
          popover_header = $(`#gantt .leftPanel .row.name .fn-label.${popover_header}`).text();
          popover_percentage = $(this).attr("class").split(' ')[3];
          return `${this.textContent} | ${popover_percentage.replace("w","")}%`; 
        },
        trigger: "hover",
        placement: "auto left"
      }).on('shown.bs.popover', function () {
        $('.popover').addClass(popover_color);
        $('.popover .popover-title').text(popover_header);
      })
      break;
    // ---------------------------------- default ------------------------------------ //
    default:
  }
}