$(document).ready(function(){
  getAPIParams({}, 'get_gantt_list');
});

// ################################## GET API PARAMS OPERATION ################################# //
function getAPIParams(data, api) {
	if (typeof(data) == 'string' && data != '' && isJson(data)) { data = JSON.parse(data) }
	let APIs = {
		"get_gantt_list": {
			"url": "https://soporte.globalb.co/apitest.php",
			"method": "GET",
			"success": "success_get_gantt_list"
		},
	}
	let url = APIs[api]['url'];
	let method = APIs[api]['method'];
	let success = APIs[api]['success'];
	API_control(url, data, method, success);
}

// #################################### API CONTROL OPERATION ################################## //
function API_control(url, data, method, success) {
	let formData = '', send_formdata = false;
	data['_method'] = method;
	data['userId'] = $("#current_user_id").val();
	// if (data['contains_file']) {
	// 	formData = new FormData();
	// 	Object.entries(data).forEach(([key, value]) => { formData.append(key, value) });
	// 	data = formData;
	// 	send_formdata = true;
	// }
	$("#loader").css("display","flex");
  console.log("-----------------------------------");
  console.log(data);
  console.log("-----------------------------------");
	$.ajax({
		url: url,
		data: data,
		processData: send_formdata ? false : true,
		contentType: send_formdata ? false : 'application/x-www-form-urlencoded; charset=UTF-8',
		headers: {
			'X-XSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
		},
		type: method,
		success: function(dataResponse) {
			// console.log(dataResponse);
			dataResponse = JSON.parse(dataResponse);
			console.log(dataResponse);
      console.log("-----------------------------------");
			$("#loader").hide();
			$("label > i.validate_icon").remove();
			let error = dataResponse['message'];
      successAPI(success, dataResponse);
		},
		error: function(error) {
			console.log(error);
			$("#loader").hide();
			// modalControl('error_api');
		}
	});
}	

// ######################################### SUCCESS API ####################################### //
function successAPI(success, data) {
  switch (success) {
    // ------------------------ success_get_list_applications ------------------------ //
    case "success_get_gantt_list":
      var groupBy = function(xs, key) {
        return xs.reduce(function(rv, x) {
          (rv[x[key].trim()] = rv[x[key].trim()] || []).push(x);
          return rv;
        }, {});
      };
      data = groupBy(data, 'hitoname');
      let data_gantt = [], counter = 0;
      Object.values(data).map((sprint, index1) => {
        sprint.map((task, index2) => {
          let data = {
            desc: task['tareaname'],
            values: [{
              from: moment(task['inicio']).valueOf(),
              to: moment(task['fin']).valueOf(),
              label: task['tareaname'],
              customClass: `color${counter} header${index1}`
            }],
          }
          if (index2 == 0) { 
            data['name'] = task['hitoname'];
            data['cssClass'] = `header${index1} c${index1}`
          }
          data_gantt.push(data);
        });
        counter++
        if (counter > 3) { counter = 0 }
      })
      $("#gantt").gantt({
        source: data_gantt,
        navigate: "scroll",
        scale: "days",
        minScale: "days",
        maxScale: "months",
        itemsPerPage: 10,
        scrollToToday: false,
        // useCookie: true,
        dow: ["D", "L", "M", "M", "J", "V", "S"],
        waitText: 'Cargando...',
        // onItemClick: function(data) {
        //   alert("Item clicked - show some details");
        // },
        // onAddClick: function(dt, rowId) {
        //   alert("Empty space clicked - add an item!");
        // },
        onRender: function() {
          $("#gantt .row.name").each(function(){
            let color = $(this).find(".fn-label").attr("class").split(' ')[2];
            if (color) { $(this).addClass(`color${color.split('')[1]}`) }
          })
        }
      });
      $("#gantt").popover({
        selector: ".bar",
        title: function _getItemText() { return ' '; },
        container: '#gantt',
        content: function _getItemText() { 
          popover_color = $(this).attr("class").split(' ')[1];
          popover_header = $(this).attr("class").split(' ')[2];
          popover_header = $(`#gantt .leftPanel .row.name .fn-label.${popover_header}`).text();
          return this.textContent; 
        },
        trigger: "hover",
        placement: "auto right"
      }).on('shown.bs.popover', function () {
        $('.popover').addClass(popover_color);
        $('.popover .popover-title').text(popover_header);
      })
      break;
    // ---------------------------------- default ------------------------------------ //
    default:
  }
}